/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import cz.insophy.inplan.util.Comparators;

public final class MathUtils {
    private MathUtils() {
    }

    public static double roundQtyWrtGranularityUp(double qty, double granularity) {
        if (granularity <= 0.0) {
            return qty;
        }
        double d = qty / granularity;
        d = Comparators.compare(Math.floor(d), d, 1.0E-7) == 0 ? Math.floor(d) : Math.ceil(d);
        return d * granularity;
    }

    public static double roundQtyWrtGranularityDown(double qty, double granularity) {
        if (granularity <= 0.0) {
            return qty;
        }
        double d = qty / granularity;
        d = Comparators.compare(Math.ceil(d), d, 1.0E-7) == 0 ? Math.ceil(d) : Math.floor(d);
        return d * granularity;
    }

    public static double clamp(double val, double min2, double max) {
        if (val < min2) {
            return min2;
        }
        if (val > max) {
            return max;
        }
        return val;
    }
}

